﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.VistaIntegration.FacadeContracts.Admin;
using System.Text;
using BMS.Utils;
using BMS.Facade.Data;

namespace BMS.Web.Models
{
    public class NumiViewModel : BaseViewModel
    {
        public string SelectedCalendarId { get; set; }
        public IList<JobCalendar> Calendars { get; set; }
        public IList<NumiEntry> NumiEntries { get; set; }

        public static string GetVistASitesText(NumiEntry entry)
        {
            if (!entry.Sites.Any()) return string.Empty;

            StringBuilder sb = new StringBuilder();
            entry.Sites.ForEach(e =>
                {
                    sb.Append(e.Name);
                    sb.Append("; ");
                });
            sb.Remove(sb.Length - 2, 2);
            return sb.ToString();
        }
    
    }
}